<?php
/* --------------------------------------------------------------
  index.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

require __DIR__ . '/bootstrap.inc.php';

if(!\StyleEdit\Authentication::isAuthenticated())
{
	\StyleEdit\Authentication::showForbiddenPage();
}

$environment = (isset($_GET['debug'])) ? 'development' : 'production';
$fileSuffix  = ($environment === 'development') ? '' : '.min';
?>

<!DOCTYPE html>
<html>
	<head>
		<title>StyleEdit v3 by Gambio GmbH</title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<link rel="icon"  type="image/png" href="assets/images/favicon.ico">
		<link rel="stylesheet" href="assets/styles/vendor<?php echo $fileSuffix; ?>.css">
		<link rel="stylesheet" href="assets/styles/style_edit<?php echo $fileSuffix; ?>.css">
	</head>
	<body>
		<div class="style-edit-container">
			
			<!--
				// ------------------------------------------------------------------------------------
				// STYLE EDIT PREVIEW
				// 
				// The preview will be set dynamically from the "TemplatePreview" widget.
				// ------------------------------------------------------------------------------------
			-->
			<div class="style-edit-preview"></div>
			
			
			<!--
				// ------------------------------------------------------------------------------------
				// STYLE EDIT FRAME
				// 
				// The right-side container for the application.
				// ------------------------------------------------------------------------------------
			-->
			<div class="style-edit-frame open">
				
				<div class="frame-toggle">
					<i class="fa fa-caret-right"></i> <i class="fa fa-caret-left"></i>
				</div>
				
				<div class="main container">
					<div class="ajax-spinner full-height-frame">
						<!-- Content Dynamically Generated -->
					</div>
					
					<div class="error-frame full-height-frame">
						<div class="content-wrapper">
							<i class="fa fa-exclamation-triangle"></i>
							<div class="message">Unexpected Error</div>
						</div>
					</div>
					
					<!--
						HEADLINE
					-->
					<div class="style-edit-headline">
						<div class="col-xs-9 title">
							<h1>
								<strong>Gambio</strong> StyleEdit
							</h1>
						</div>
						<div class="col-xs-3 preview-resizer withripple" data-ripple-color="#000000">
							<div class="type-toggle" data-toggle="dropdown">
								<i class="fa fa-desktop"></i>
							</div>
							
							<ul class="dropdown-menu">
								<!-- Dynamically Generated -->
							</ul>
						</div>
					</div>
					
					<!--
						VIEW CONTAINER
					-->
					<div class="style-edit-view">
						<!-- Dynamically Generated -->
					</div>
				</div>
			</div>
		</div>
		
		
		<!--
			// ------------------------------------------------------------------------------------
			// MUSTACHE TEMPLATES
			// ------------------------------------------------------------------------------------
		-->
		<?php
		// Include StyleEdit3 Templates
		$htmlTemplateLoader = new \StyleEdit\HtmlTemplateLoader(__DIR__ . '/html');
		echo $htmlTemplateLoader->asHtml();
		?>
		
		
		<!--
			// ------------------------------------------------------------------------------------
			// INCLUDE JAVASCRIPT
			// ------------------------------------------------------------------------------------
		-->
		<script type="text/javascript" src="assets/javascript/vendor<?php echo $fileSuffix; ?>.js"></script>
		<script type="text/javascript" src="assets/javascript/style_edit<?php echo $fileSuffix; ?>.js"></script>
	</body>
</html>
